function [idx_list] = vb_info_get_active_channel_index(info, ch_type)
% return active channel index list
% [usage]
%   [idx_list] = vb_info_get_active_channel_index(info, ch_type)
% [input]
%       info : <required> <<struct>> MEGinfo or EEGinfo
%    ch_type : <optional> <<integer>> channel type [1]
%            :  1) MEG or EEG channels
%            :  2) only extra channels
%            :  3) all channels
% [output]
%   idx_list : [N_activeCh x 1] active channel index list
% [note]
%   @see vb_info_get_active_channel.m
% [history]
%   2008-04-16 (Sako) initial version
%   2008-06-05 (Sako) added ch_type
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('info', 'var'), info = []; end
if ~exist('ch_type', 'var'), ch_type = []; end
[info, ch_type] = inner_check_arguments(info, ch_type);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
if vb_info_active_channel_is_valid(info)
  switch ch_type
    case 1
      % MEG or EEG channels
      active_list = vb_info_get_active_channel(info, 1);
      idx_list = find(active_list == 1);
      return;
      
    case 2
      % only extra channels
      active_list = vb_info_get_active_channel(info, 2);
      idx_list = info.ExtraChannelInfo.Channel_id(active_list == 1);
      return;
      
    case 3
      idx_list = ...
        [vb_info_get_active_channel_index(info,1); ...
         vb_info_get_active_channel_index(info,2)];
      return;
  end
end

% --- no ActiveChannel field in info
Measurement = vb_info_get_measurement(info);
switch Measurement
  case 'MEG'
%     [ch_idx,ch_idx_arg,active_list] = vb_meginfo_get_channel_index_meg(info);
    [ch_idx] = vb_meginfo_get_channel_index_meg(info, [], true);
    idx_list = ch_idx(active_list == 1);
  case 'EEG'
    idx_list = vb_eeginfo_get_channel_index(info, true);
    return;
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [info, ch_type] = inner_check_arguments(info, ch_type)
if isempty(info)
  error('(%s)info is a required parameter\n', mfilename);
end

if isempty(ch_type)
  ch_type = 1;
elseif ~isnumeric(ch_type)
  error('(%s)ch_type must be specify as numeric');
end
return;
%
% --- end of inner_check_arguments()
% 
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
