function value = vb_info_get_Nrepeat(info)
% <<getter>> return Nrepeat value of MEGinfo or EEGinfo
% [usage]
%   value = vb_info_get_trial_number(info)
% [input]
%    info : <required> <<struct>> MEGinfo or EEGinfo
% [output]
%   value : value of Nrepeat field
% [note]
%   if there is not Nrepeat field, return zero.
% [history]
%   2008-04-15 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('info', 'var'), info = []; end
[info] = inner_check_arguments(info);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
value = info.Nrepeat;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [info] = inner_check_arguments(info)
func_ = mfilename;
if isempty(info)
  error('(%s)info is a required parameter', func_);
end

if ~isfield(info, 'Nrepeat')
  info.Nrepeat = 0;
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
