function	[jx, jj] = vb_onset_check(ix,t_length)
% Check onset time 
% --- condition for onset
% Time length to previous onset shoud be larger than 't_length'
%    [jx, jj] = vb_onset_check(ix,t_length)
% --- input
% ix : onset time index
% t_length : time length
% --- Output
% jx : extracted onset time index
% jj : extracted index : jx = ix(jj)
%      
% 2011-12-16 Masa-aki Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

N  = length(ix);
jj = 1;
jx = ix(1);

ipre = ix(1);

for n=2:N
	dx = ix(n) - ipre;
	if dx >= t_length
		jx = [jx, ix(n)];
		jj = [jj, n];
		ipre = ix(n);
	end
end

return

