function	[yth, A ,hy ,ylist] = vb_gamma_dist_param(y, p_val)
% Estimate threshold by approximating histgram by gamma distribution
%    [yth] = vb_gamma_dist_param(y, p_val)
%    [yth, A ] = vb_gamma_dist_param(y, p_val)
%    [yth, A ,hy ,ylist] = vb_gamma_dist_param(y, p_val)
%    
% y    : signal
% p_val: P-value corresponding to the threshold
%
% --- Output
% yth   : threshold value
% A     : gamma distribution parameter
%         log(p(y)) = A(1)*y + A(2)*log(y) + A(3)
% hy : histgram of y
% ylist : list of y corresponding to hy
%
% 2009-09-05 Masa-aki Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

debug=0;

% y0 : upper limit to estimate mean(y) : cumsum(p(y)) = p_0
p_0  = 2/3; %p_0  = 3/4;
rate = 0.1;

T = length(y);
y = abs(y(:));

Nbin = min(5000,fix(T/10));

% histgram
[hy ,ylist] = hist(y,Nbin);

% --- DEBUG
if debug==1
	ymin = ylist(1)
end

% cummulative probality
py = cumsum(hy)/T;

% estimate mean & variance excluding outlier
ix = find( py > p_0 );
y0 = ylist(ix(1));
jj = find(y < y0);
ym = mean(y(jj));
yd = sqrt(mean((y(jj)-ym).^2));

% upper & lower limit of y when estimating gamma distribution
ylow = max(ym-yd, eps);
yup  = ym + 2*yd;
%yup  = y0;

if debug==1
	fprintf('ym=%g, yup=%g, ylow=%g\n',ym, y0,ylow)
end

ii = find((ylist <= yup));
%ii = find( (ylist >= ylow) & (ylist <= yup));
%ii = find( (ylist >= ylow) );
%ii = find( (ylist >= ylow) & (ylist <= y0));
%ii = find( (ylist >= eps) & (ylist <= yup));

z = hy(ii);
x = ylist(ii);

% exclude low value of histgram
ix = find( z > max(z)*rate );

if debug==1
	Nhist = length(ix)
end

x = x(ix);
z = z(ix);
x = x(:);
z = z(:);
N = length(x);

% parameter estimation for Gamma PDF
Z  = log(z);
X  = [ x , log(x), ones(N,1)];
XX = X' * X;
XZ = X' * Z;
A  = XX \ XZ;

%py = exp( A(1)*x + A(2)*log(x) + A(3));
%errA = mean(abs(z - py));
errA = mean(abs(Z - X * A));

% parameter estimation for exponential PDF
X = [ x , ones(N,1)];
XX = X' * X;
XZ = X' * Z;
B = XX \ XZ;

%py = exp( B(1)*x + B(2));
%errB = mean(abs(z - py));
errB = mean(abs(Z - X * B));

if A(1) > 0 || A(2) < 0 || errA > errB
	fprintf('ym=%g, ylow=%g\n',ym/max(y), ylow/max(y))
	fprintf('Max Y for PDF = %g\n', yup/max(y))
	fprintf('Exponential PDF seems to be better than Gamma PDF\n')
	fprintf('Estimated Gamma PDF = exp( %g *y + %g *log(y) )\n',A(1:2))
	fprintf('Estimated Exp   PDF = exp( %g *y )\n',B(1))
	A = [B(1) 0 B(2)];
end

if A(1) > 0
	fprintf('gamma pdf estimation error\n')
end

% estimated gamma distribution
if A(2)==0
	ii = find( ylist >= 0);
	
	yl = ylist(ii);
	p  = exp( A(1)*yl + A(3));
else
	ii = find( ylist > 0);
	
	yl = ylist(ii);
	p  = exp( A(1)*yl + A(2)*log(yl) + A(3));
end

psum = cumsum(p)/sum(p);

% threshold corresponding to p_val
ii = find(psum > 1 - p_val);
yth = yl(ii(1));

% x = gaminv(p,a,b) 
% K}ݐϕz֐ɑ΂āAm p ^l x vZ
%
% gamma(x,a,b)  exp(-x/b) x^(a-1) = exp( -x/b + (a-1)*log(x) )
% pdf  = exp( A(1)*x + A(2)*log(x) );
% p = int_0^x dt gamma(t,a,b)
% a = A(2) + 1  : A(2) = a - 1
% b = - 1/A(1)  : A(1) = -1/b
%

if debug == 2
	ix = find( (y >= ylow) & (y <= yup));
	B = gamfit(y(ix));
	A = [ - 1/B(2) , B(1) - 1, 1];
	yth0 = yth;
	yth  = gaminv(1-p_val, A(2)+1, -1/A(1))/max(y);
	dif_yth  = (yth - yth0)
end

return


% y = C * py

C = (y'*py) / sum(py.^2);

py = C * py;
