function	ix = vb_bit_ptn_start(y,status,t_stay)
% Find time points that signal changes to the given integer bit pattern
% only specified bits are examined and other bits are ignored 
% by taking bitwise AND
%     ix = vb_bit_ptn_start(y,status)
%     ix = vb_bit_ptn_start(y,status,t_stay)
% y : event signal
% status : integer defined by bit pattern
%        = 2^n : correspond to check n-th bit
% t_stay : minimum length to stay the specified value [default = 10]
%          'y' should be stay at the value 'status' for more than t_stay
% 
% ix : index corresponding to the start point 
%      'y' changes to 'status' from other value
%      
% 2009-6-11 Masa-aki Sato
% 2012-1-8  Masa-aki Sato Bug fix
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if nargin < 3, t_stay = 10; end;

T = length(y);

% take bitwise AND to ignore irrelevant bit
y = bitand(y,status);

flg = ones(1,T-t_stay);
tt  = 1:T-t_stay;

% 'y' is not 'status' value beforehand
flg = flg .* (y(tt) ~= status);

% 'y' should be stay at the value 'status' for more than t_stay
for t=1:t_stay
	flg = flg .* (y(tt + t) == status);
end

ix = find(flg == 1);

return
