function [channel_type] = vb_yokogawa_get_channel_type(select_code)
% return channel type definition
%
% [usage]
%   [channel_type] = vb_yokogawa_get_channel_type(select_code)
%
% [input]
%   select_code : <optional> which channel do you want?
%               : 1 || 2 || 4 or bitor of them
%               :    1) MEG
%               :    2) EXTRA
%               :    4) REFERENCE
%               :  [7]) all
%
% [output]
%   channel_type : <<struct>> [Ntype x 1]
%                :  .id   : defined by YOKOGAWA
%                :  .name : defined by ATR
%
% [note]
%
% [history]
%   2008-02-01 (Sako) initial version
%   2008-05-16 (rhayashi) repair misspelled(Planner -> Planar)
%   2011-06-24 (Sako) modified to increment type_index after EtcChannel
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- local constant
CH_MEG = 1;
CH_EXT = 2;
CH_REF = 4;

% --- DEFINITION of SENSOR TYPE ID
NullChannel         = 0;
MagnetoMeter        = 1;
AxialGradioMeter    = 2;
PlanarGradioMeter   = 3;

% ReferenceChannelMark
RCMark = hex2dec('0100');
% Ref_ means Reference
Ref_MagnetoMeter       = bitor(RCMark, MagnetoMeter);
Ref_AxialGradioMeter   = bitor(RCMark, AxialGradioMeter);
Ref_PlanarGradioMeter  = bitor(RCMark, PlanarGradioMeter);

TriggerChannel      = -1;
EegChannel          = -2;
EcgChannel          = -3;
EtcChannel          = -4;

% set channel_type fields
type_index = 1;

if bitand(select_code, CH_MEG) == CH_MEG
  channel_type(type_index).id = MagnetoMeter;
  channel_type(type_index).name = 'MagnetoMeter';
  type_index = type_index + 1;

  channel_type(type_index).id = AxialGradioMeter;
  channel_type(type_index).name = 'AxialGradioMeter';
  type_index = type_index + 1;

  channel_type(type_index).id = PlanarGradioMeter;
  channel_type(type_index).name = 'PlanarGradioMeter';
  type_index = type_index + 1;
end

% --- EXTRA CHANNEL
if bitand(select_code, CH_EXT) == CH_EXT
  channel_type(type_index).id = NullChannel;
  channel_type(type_index).name = 'NullChannel';
  type_index = type_index + 1;

  channel_type(type_index).id = TriggerChannel;
  channel_type(type_index).name = 'TriggerChannel';
  type_index = type_index + 1;

  channel_type(type_index).id = EegChannel;
  channel_type(type_index).name = 'EegChannel';
  type_index = type_index + 1;

  channel_type(type_index).id = EcgChannel;
  channel_type(type_index).name = 'EcgChannel';
  type_index = type_index + 1;

  channel_type(type_index).id = EtcChannel;
  channel_type(type_index).name = 'EtcChannel';
  type_index = type_index + 1;
end

% --- REFERENCE CHANNEL
if bitand(select_code, CH_REF) == CH_REF
  channel_type(type_index).id = Ref_MagnetoMeter;
  channel_type(type_index).name = 'ReferenceMagnetoMeter';
  type_index = type_index + 1;

  channel_type(type_index).id = Ref_AxialGradioMeter;
  channel_type(type_index).name = 'ReferenceAxialGradioMeter';
  type_index = type_index + 1;

  channel_type(type_index).id = Ref_PlanarGradioMeter;
  channel_type(type_index).name = 'ReferencePlanarGradioMeter';
  type_index = type_index + 1;
end

channel_type = channel_type';
return;

% --- END OF FILE --- %
