function [meg_info] = vb_ykgwfile_get_calibinfo(ykgwfile, meg_info)
% return calibration information by including on the MEGinfo
%
% [usage]
%   [meg_info] = ykgwfile_get_calibinfo(ykgwfile, meg_info)
%
% [input]
%   ykgwfile : <required> <<file>> data file path
%   meg_info : <optional> <<struct>> base of information
%            :  If this is invalid, new meg_info will be created.
%
% [output]
%   meg_info : <<struct>> updated meg_info
%            :  .sensor_gain   [n_channel x 1]
%            :  .sensor_offset [n_channel x 1]
%            :  .FLL_gain      [n_fll x 1]
%
% [note]
%   change sensor_gain size from only active_ch to all
%
%   See also
%     getYkgwHdrCalib
%
% [history]
%   2007-06-28 (Sako) initial version
%   2011-07-19 (Sako) modified to use the new YOKOGAWA library
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('ykgwfile', 'var'), ykgwfile = ''; end
if ~exist('meg_info', 'var'), meg_info = []; end
[ykgwfile, meg_info] = inner_check_arguments(ykgwfile, meg_info);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
calib_info = getYkgwHdrCalib(ykgwfile);

% --- <calib_info>
%       .sensitivity <<struct array>>
%         .gain
%         .offset
%
%       .fll <<struct array>>
%         .gain
%
%       .ad  <<struct>>
%         .bit
%         .analog_range [Volt]

meg_info.sensor_gain   = vb_calibinfo_get_sensor_gain(calib_info);
meg_info.sensor_offset = vb_calibinfo_get_sensor_offset(calib_info);
meg_info.FLL_gain      = vb_calibinfo_get_fll_gain(calib_info);

% --- bit lenght of data
meg_info = vb_meginfo_set_data_bit_len(meg_info, meg_info.calib_info.ad.bit);

% --- sensor label - set default
meg_info.calib_info = vb_calibinfo_set_sensor_label(meg_info.calib_info);

% --- new format of yokogawa
meg_info.calib_info = calib_info;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [ykgwfile, meg_info] = inner_check_arguments(ykgwfile, meg_info)
func_ = mfilename;

if isempty(ykgwfile)
  error('(%s)ykgwfile is a required parameter', func_);
end

if isempty(meg_info)
%   error('(%s)meg_info is a required parameter', func_);
end

if exist(ykgwfile, 'file') ~= 2
  error('(%s)cannot find yokogawa file : %s', func_, ykgwfile);
end

return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
