function [MEGinfo,bexp,pick,Qpick] = vb_yokogawa_channel_rejection(MEGinfo,bexp,pick,Qpick,reject_channel)
% Reject the selected channels from bexp,pick,Qpick,MEGinfo.sensor_weight.
%
% [MEGinfo,bexp,pick,Qpick] = ...
%     vb_yokogawa_channel_rejection(MEGinfo,bexp,pick,Qpick,reject_channel)
% [IN]
%   MEGinfo : struct with MEG acquisition information
%       .MEGch_id       % Active MEG channel index (absolute channel index)
%       .sensor_weight  % weight to calculate lead field
%       .Nchannel       % number of active gardiometers
%   bexp(ch,t,trial)       : MEG data (Channel, Time, Trial)
%   pick(ch,          1:3) : position of detector coils.
%       (ch+Nchannel, 1:3) : position of conpensation coils.
%   Qpick(ch,         1:3) : direction of detector coils.
%       (ch+Nchannel, 1:3) : direction of conpensation coils.
%   reject_channel        : vector of rejected channel number .
%                           absolute channel index
% [OUT]
%   MEGinfo : struct with MEG acquisition information after rejection
%       .MEGch_id       % Active MEG channel index (absolute channel index)
%       .MEGch_name     % Active MEG channel name
%       .sensor_weight  % weight to calculate lead field
%       .Nchannel       % number of active gardiometers after rejection
%   bexp(ch,t,trial)       : MEG data (Channel, Time, Trial) after rejection
%   pick(ch,          1:3) : position of detector coils.
%       (ch+Nchannel, 1:3) : position of conpensation coils.
%   Qpick(ch,         1:3) : direction of detector coils.
%       (ch+Nchannel, 1:3) : direction of conpensation coils.
%
% MEG channel index 
% MEGinfo.MEGch_id  : Active MEG channel index (absolute channel index)
%   bexp(ch,:)              <-> MEGinfo.MEGch_id(n)
%   pick(ch,          1:3)  <-> MEGinfo.MEGch_id(n)
%       (ch+Nchannel, 1:3)  <-> MEGinfo.MEGch_id(n)
%   Qpick(ch,         1:3)  <-> MEGinfo.MEGch_id(n)
%       (ch+Nchannel, 1:3)  <-> MEGinfo.MEGch_id(n)
%
%   2006-05-08 Masanori Osako
%   2006-05-14 M. Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% Absolute channel innex for bexp, pick & Qpick
MEGch_id = MEGinfo.MEGch_id;
MEGch_name = MEGinfo.MEGch_name;
Nchannel = length(MEGch_id);

% Extract active channel index from 'MEGch_id' different from 'reject_channel'
MEG_act = vb_setdiff2(MEGch_id, reject_channel);

MEGinfo.Nchannel = length(MEG_act);
MEGinfo.MEGch_id = MEG_act;
MEGinfo.MEGch_name = MEGch_name(MEG_act);

Nmax   = max(MEGch_id);

if max(reject_channel) > Nmax,
	error('Reject channel index is larger than channel number');
end

if Nchannel ~= (MEGinfo.Nchannel + length(reject_channel))
	error('Reject channel index is not in channel index');
end

% Convert absolute index to relative index
itrans = zeros(Nmax,1);
itrans(MEGch_id) = 1:Nchannel;

id_act = itrans(MEG_act);				% active channel index
ix_act = [id_act ; id_act + Nchannel];	% active coil index

% Extract active channel
bexp  = bexp(id_act,:,:);

pick  = pick(ix_act,:);
Qpick = Qpick(ix_act,:);

sensor_weight = MEGinfo.sensor_weight(id_act,:);
MEGinfo.sensor_weight = sensor_weight(:,ix_act);
