function	[pos, id] = vb_read_yokogawa_pos(fname,Nmark)
% This function reads yokogawa's Marker file(text file)
%
% pos : marker position [N x 3]
% id  : marker id
% fname : marker text file
% Nmark : number of marker (Optional, Default = 5)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('fname','var')
	fname = 'AEFޡ.txt';
end

key_start = 'MEG marker file';
key_mark  = 'Marker';
key_end   = '[mm]';

xkey = 'x=';
ykey = 'y=';
zkey = 'z=';

if ~exist('Nmark','var')
	Nmark = 5;
end

id  = zeros(Nmark,1);
pos = zeros(Nmark,3);

fid=fopen(fname);

if fid == -1, fprintf('[%s] can not be opened\n',fname);return; end;

% Check keyname
while 1
    next_line = fgetl(fid);
    if ~ischar(next_line), break, end;
	if ~isempty( strfind(next_line,key_start)), break, end;
end

for n = 1:Nmark
    next_line = fgetl(fid);
	js = strfind(next_line,key_mark);
	je = strfind(next_line,key_end);
	jx = strfind(next_line,xkey);
	jy = strfind(next_line,ykey);
	jz = strfind(next_line,zkey);

	id(n)    = sscanf(next_line(js+6:js+7)      ,'%d');
	pos(n,1) = sscanf(next_line(jx(1)+2:jy(1)-1),'%f');
	pos(n,2) = sscanf(next_line(jy(1)+2:jz(1)-1),'%f');
	pos(n,3) = sscanf(next_line(jz(1)+2:je-1)   ,'%f');
end

% Change unit [mm] -> [m]
pos = pos*0.001;

fclose(fid);

return
%
% ---- END ----
%



next_line1 = ...
'	MEG marker file:  C:\Documents and Settings\meg.MEG-SYSTEM\ǥȥå\ATR͸ȥ졼˥\20060203\¼±\AEFޡ.mrk';

next_line = ...
'	Marker 1:   MEG:x=   -3.87, y=   89.27, z=  -12.05[mm]    MRI:x=********, y=********, z=********    ';


~isempty( strfind(next_line1,key_start))

%return

next_line(js+6:js+7)      
next_line(jx(1)+2:jy(1)-1)
next_line(jy(1)+2:jz(1)-1)
next_line(jz(1)+2:je-1)   
