function	vb_check_sensor_direction(megfile)
% plot pick and Qpick on the same figure and plot Qpick and pick vector
% 
%-- Syntax
% vb_check_sensor_direction(megfile)
%
%-- Input 
% megfile : meg.mat file name  
%
%-- Output
% figure1 : pick and Qpick
% figure2 : pick-Qpick vector
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

[pick,Qpick,Wsensor,Vcenter] = vb_load_sensor(megfile);

figure
pick_num = size(pick,1)/2;
plot3(pick(1:pick_num,1),pick(1:pick_num,2),pick(1:pick_num,3),'ob');
hold on; 
plot3(pick(pick_num+1:end,1),pick(pick_num+1:end,2),pick(pick_num+1:end,3),'or');
title('pick(blue point) and Qpick(red point)')
axis equal

figure
Qpick_pick=0.005*Qpick(1:pick_num,:)+pick(1:pick_num,:);
plot3(pick(1:pick_num,1),pick(1:pick_num,2),pick(1:pick_num,3),'ob');
hold on
for n=1:pick_num,
    plot3([pick(n,1);Qpick_pick(n,1)],[pick(n,2);Qpick_pick(n,2)],[pick(n,3);Qpick_pick(n,3)],'-');
end
title('pick-Qpick vector')
axis equal
