function [meg_info] = vb_meginfo_set_sensor_weight_refmg(meg_info, s_weight)
% set sensor weight for refmg channels to MEGinfo
% [usage]
%   [meg_info] = vb_meginfo_set_sensor_weight_refmg(meg_info, s_weight)
% [input]
%   meg_info : <required> <<struct>> MEGinfo
%            :  If this is empty, return new MEGinfo only with sensor weight
%            :  for refmg
%   s_weight : <required> [n_channel x 1] sensor weight for refmg channels
%            :  If this is empty, set empty field
% [output]
%   meg_info : updated MEGinfo
%            :  MEGinfo.device_info.sensor_weight_ref
% [note]
%
% [history]
%   2011-07-20 (Sako) initial version

% --- CHECK ARGUMENTS --- %
if ~exist('meg_info', 'var'), meg_info = []; end
if ~exist('s_weight', 'var'), s_weight = []; end
[meg_info, s_weight] = inner_check_arguments(meg_info, s_weight);


% --- MAIN PROCEDURE --------------------------------------------------------- %
%
meg_info.device_info.sensor_weight_ref = s_weight;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %


% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [meg_info, s_weight] = inner_check_arguments(meg_info, s_weight)
if isempty(meg_info)
  % do nothing
end

if isempty(s_weight)
  % do nothing
  % --- set empty field
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
