function [MEGinfo] = vb_meginfo_set_post_trigger(MEGinfo, value)
% set post-trigger value to current MEGinfo struct
% [usage]
%   [MEGinfo] = vb_meginfo_set_post_trigger(MEGinfo, value)
% [input]
%   MEGinfo : <required> <<struct>> MEG information
%     value : <optional> value of post-trigger [[]]
% [output]
%   MEGinfo : <<struct>> updated MEGinfo
% [note]
%   post-trigger field is not actually defined in MEGinfo
%   this function is to be symmetric with EEGinfo functions
% [hisotory]
%   2007-08-02 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('MEGinfo', 'var'), MEGinfo = []; end
if ~exist('value', 'var'), value = []; end
[MEGinfo, value] = inner_check_arguments(MEGinfo, value);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
MEGinfo.Posttrigger = value;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [MEGinfo, value] = inner_check_arguments(MEGinfo, value)
func_ = mfilename;
if isempty(MEGinfo)
  error('(%s)MEGinfo is a required parameter', func_);
end

if isempty(value)
  % require no action - set empty
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
