function [meginfo] = vb_meginfo_set_channel_number(meginfo, n_channel)
% <<setter>> number of channel of MEGinfo
% [usage]
%   [meginfo] = vb_meginfo_set_channel_number(info, n_channel)
% [input]
%     meginfo : <required> <<struct>> MEGinfo
%   n_channel : <optional> channel number [0]
% [output]
%     meginfo : MEGinfo after updating
% [note]
%
% [history]
%   2008-02-21 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('meginfo', 'var'), meginfo = []; end
if ~exist('n_channel', 'var'), n_channel = []; end
[meginfo, n_channel] = inner_check_arguments(meginfo, n_channel);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
meginfo.Nchannel = n_channel;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [meginfo, n_channel] = inner_check_arguments(meginfo, n_channel)
func_ = mfilename;
if isempty(meginfo)
  error('(%s)meginfo is a required parameter', func_);
end

if isempty(n_channel)
  n_channel = 0;
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
