function [meginfo] = vb_meginfo_set_acqinfo(meginfo, acqinfo)
% <<setter>> of acq_info field of MEGinfo
% [usage]
%   [meginfo] = vb_meginfo_set_acqinfo(meginfo, acqinfo)
% [input]
%   meginfo : <required> <<struct>> MEGinfo
%   acqinfo : <optional> <<struct>> the fields of which are as follows []
%           :  .data_file : import data file
%           :  .data_bit_len : bit length of stored binary data
%           :  .type : acquisition type of original data. e.g. 'Continuous_Raw'
% [output]
%   meginfo : <<struct>> MEGinfo after updating
% [note]
%   The new standard format was defined. (2011-05)
% [history]
%   2008-02-21 (Sako) initial version
%   2011-05-26 (Sako) modified according to the new format
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('meginfo', 'var'), meginfo = []; end
if ~exist('acqinfo', 'var'), acqinfo = []; end
[meginfo, acqinfo] = inner_check_arguments(meginfo, acqinfo);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
meginfo.device_info.acq_info = acqinfo;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [meginfo, acqinfo] = inner_check_arguments(meginfo, acqinfo)
func_ = mfilename;
if isempty(meginfo)
  error('(%s)meginfo is a required parameter', func_);
end

if isempty(acqinfo)
  % require no action because this will be set as it is empty
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
