function [meg_info] = vb_meginfo_init_sensor_weight_refmg(meg_info, n_ch)
% set initial sensor weight for refmg channels
% [usage]
%   [meg_info] = vb_meginfo_init_sensor_weight_refmg(meg_info, n_ch)
% [input]
%   meg_info : <required> <<struct>> MEGinfo which will be updated
%       n_ch : <required> number of refmg channels
% [output]
%   meg_info : <<struct>> updated MEGinfo
% [note]
%   initial value is eye(n_ch), n_ch by n_ch identity matrix
%    1 0 0 0
%    0 1 0 0
%    0 0 1 0
%    0 0 0 1
%   @see vb_meginfo_set_sensor_weight_refmg.m
% [history]
%   2011-07-20 (Sako) initial version

% --- CHECK ARGUMENTS --- %
if ~exist('meg_info', 'var'), meg_info = []; end
if ~exist('n_ch', 'var'), n_ch = []; end
[meg_info, n_ch] = inner_check_arguments(meg_info, n_ch);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
meg_info = vb_meginfo_set_sensor_weight_refmg(meg_info, eye(n_ch) );
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %


% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [meg_info, n_ch] = inner_check_arguments(meg_info, n_ch)
func_ = mfilename;
if isempty(meg_info)
  error('(%s) meg_info is a required parameter', func_);
end

if isempty(n_ch)
  error('(%s) n_ch is a required parameter', func_);
end
return;
%
% --- end of inner_check_arguments()

% --- END OF FILE --- %
