function ch_type = vb_meginfo_get_channel_type_extra(meg_info)
% return type list of extra channels
% [usage]
%   ch_type = vb_meginfo_get_channel_type_extra(meg_info)
% [input]
%   meg_info : <required> <<struct>> MEGinfo which has 'ExtraChannelInfo'
% [output]
%   ch_type : list of channel type
% [note]
%   return value includes reference channels if exist
% [history]
%   2008-02-01 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('meg_info', 'var'), meg_info = []; end
[meg_info] = inner_check_arguments(meg_info);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
ch_type = meg_info.ExtraChannelInfo.Channel_type;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [meg_info] = inner_check_arguments(meg_info)
func_ = mfilename;
if isempty(meg_info)
  error('(%s)meg_info is a required parameter', func_);
end

if ~isfield(meg_info, 'ExtraChannelInfo')
  error('(%s)meg_info must have ExtraChannelInfo field', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
