function [ch_name] = vb_meginfo_get_channel_name_extra(meg_info, type_id)
% return channel name list which you want to get
% [usage]
%   [ch_name] = vb_meginfo_get_extra_channel_name(meg_info, type_id)
% [input]
%   meg_info : <required> <<struct>> MEGinfo which must have ExtraChannelInfo
%    type_id : <optional> <<integer>> type id []
%            :  the case of YOKOGAWA-MEG, as follows
%            :    0) Null Channel
%            :   -1) Trigger Channel
%            :   -2) Eeg Channel
%            :   -3) Ecg Channel
%            :   -4) Etc Channel
%            :  if this is empty, return names of all channel
% [output]
%   ch_name : [N x 1] name (number) list of acceptable channels
% [note]
%
% [history]
%   2008-02-05 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('meg_info', 'var'), meg_info = []; end
if ~exist('type_id', 'var'), type_id = []; end
[meg_info, type_id] = inner_check_arguments(meg_info, type_id);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
if isfield(meg_info.ExtraChannelInfo, 'Channel_type') ...
    && isfield(meg_info.ExtraChannelInfo, 'Channel_name')
  
  if isempty(type_id)
    ch_name = meg_info.ExtraChannelInfo.Channel_name;
  else
    ch_name = ...
      meg_info.ExtraChannelInfo.Channel_name(...
        meg_info.ExtraChannelInfo.Channel_type == type_id);
  end
else
  ch_name = [];
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [meg_info, type_id] = inner_check_arguments(meg_info, type_id)
func_ = mfilename;
if isempty(meg_info)
  error('(%s)meg_info is a required parameter', func_);
end

if ~isfield(meg_info, 'ExtraChannelInfo')
  error('(%s)meg_info must have ExtraChannelInfo field', func_);
end

if isempty(type_id)
  % require no action
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
