function [labels, result] = vb_meginfo_get_channel_label_whole(meginfo, active_swt)
% return label list of whole channels which include MEG and EXTRA
% [usage]
%   [labels, result] = vb_meginfo_get_channel_label_whole(meginfo, active_swt)
% [input]
%   meginfo : <required> <<struct>> MEG information
%   active_swt : <optional> <<boolean>> active switch [false]
%              :   true) active channels in MEG channels
%              :  false) all the channels in MEG channels
% [output]
%       labels : label list of all channels [N x 1]
%       result : <<integer>> error code
%              :  0) success
%              :  1) bad meginfo
% [note]
%   @see vb_meginfo_get_channel_label_meg.m
%   @see vb_meginfo_get_channel_label_extra.m
%   @see vb_meginfo_get_channel_label_refmg.m
% [history]
%   2007-06-27 (Sako) initial version
%   2008-02-01 (Sako) modified for new spec
%   2008-04-16 (Sako) added active_swt
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('meginfo', 'var'), meginfo = []; end
if ~exist('active_swt', 'var'), active_swt = []; end
[meginfo, active_swt, result] = inner_check_arguments(meginfo, active_swt);

if result ~= 0
  return;
end

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
labels = [vb_meginfo_get_channel_label_meg(meginfo, active_swt)' ...
          vb_meginfo_get_channel_label_extra(meginfo, active_swt)' ...
          vb_meginfo_get_channel_label_refmg(meginfo, active_swt)'];
% arrange to [N x 1]
labels = vb_util_arrange_list(labels,0);
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [meginfo, active_swt, result] = ...
  inner_check_arguments(meginfo, active_swt)
func_ = mfilename;
result = 0;

if isempty(meginfo)
  fprintf('(%s)meginfo is a required parameter\n', func_);
  result = 1;
  return;
end

if isempty(active_swt)
  active_swt = false;
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
