function [data_dir] = vb_meginfo_get_bin_data_dir(meginfo)
% <getter> for MEGinfo - return binary data stored directory
% [usage]
%   [data_dir] = vb_meginfo_get_bin_data_dir(meginfo)
% [input]
%    meginfo : <required> <<struct>> MEGinfo which must have saveman field
% [output]
%   data_dir : data directory on which binary data is stored
% [note]
%   @see vb_meginfo_get_precision.m
% [history]
%   2008-02-19 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('meginfo', 'var'), meginfo = []; end
[meginfo] = inner_check_arguments(meginfo);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
if isfield(meginfo, 'saveman')
  data_dir = meginfo.saveman.data_dir;
else
  data_dir = '';
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
% 
function [meginfo] = inner_check_arguments(meginfo)
func_ = mfilename;
if isempty(meginfo)
  error('(%s)meginfo is a required parameter', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS -------------------------------------------------------- %

%%% END OF FILE %%%
