function [acq_cond] = vb_meginfo_get_acqcond(meg_info)
% MEGinfo getter for acquisition condition information
%
% [usage]
%   [acq_cond] = vb_meginfo_get_acqcond(meg_info)
%
% [input]
%   meg_info : <required> <<struct>> MEG header information
%
% [output]
%   acq_cond : acquisition condition information
%
% [note]
%   return value is MEGinfo.device_info.acq_info.condition
%   in the latest standard format.
%
% [history]
%   2011-05-26 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('meg_info', 'var'), meg_info = []; end
[meg_info] = inner_check_arguments(meg_info);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
acq_cond = [];
if isfield(meg_info, 'device_info')
  if isfield(meg_info.device_info, 'acq_info')
    if isfield(meg_info.device_info.acq_info, 'condition')
      acq_cond = meg_info.device_info.acq_info.condition;
    else
%       warning('device_info.acq_info does not have ''condition'' field\n');
    end
  else
%     warning('device_info does not have ''acq_info'' field\n');
  end
else
  if isfield(meg_info, 'acq_info')
    if isfield(meg_info.acq_info, 'condition')
      bit_len = meg_info.acq_info.condition;
    else
%       warning('acq_info does not have ''condition'' field\n');
    end
  else
%     warning('meg_info does not have ''acq_info'' field\n');
  end
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %


% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [meg_info] = inner_check_arguments(meg_info)
func_ = mfilename;
if isempty(meg_info)
  error('(%s)meg_info is a required parameter', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
