function [bexp] = vb_megfile_get_internal_data_meg(megfile)
% return meg data which is internally stored in megfile
% [usage]
%   [bexp] = vb_megfile_get_internal_data_meg(megfile)
% [input]
%    megfile : <required> <<file>> MEG-MAT file
% [output]
%       bexp : matrix of bexp field stored in MEG-MAT file
%            : [Nchannel x Nsample x Ntrial]
% [note]
%   MEG-MAT must have bexp field even if it is empty
%   This function does not provide data which is selected in sample and trial
% [history]
%   2008-02-15 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('megfile', 'var'), megfile = []; end
[megfile] = inner_check_arguments(megfile);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
func_ = mfilename;

load(megfile, 'bexp');
if ~exist('bexp', 'var')
  warning('(%s)This megfile does not have bexp field\n', func_);
  bexp = [];
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [megfile] = inner_check_arguments(megfile)
func_ = mfilename;

if isempty(megfile)
  error('(%s)megfile is a required parameter', func_);
end

if exist(megfile, 'file') ~= 2
  error('(%s)cannot find megfile : %s', func_, megfile);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
