function [label_list] = vb_megfile_get_channel_label_whole(megfile, active_swt)
% return label list of all channels by reading megfile
% [usage]
%   [label_list] = vb_megfile_get_channel_label_whole(megfile, active_swt)
% [input]
%      megfile : <required> <<file>> MEG-MAT file
%   active_swt : <optional> <<boolean>> active switch [false]
%              :   true) active channels in MEG channels
%              :  false) all the channels in MEG channels
% [output]
%   label_list : label list of all channels
% [note]
%   @see vb_meginfo_get_channel_label_whole
% [history]
%   2007-07-18 (Sako) initial version
%   2008-05-01 (Sako) added active_swt
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('megfile', 'var'), megfile = []; end
if ~exist('active_swt', 'var'), active_swt = []; end
[megfile, active_swt] = inner_check_arguments(megfile, active_swt);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
label_list = [];

meginfo = vb_megfile_load_meginfo(megfile);
if isempty(meginfo)
  return;
end

label_list = vb_meginfo_get_channel_label_whole(meginfo, active_swt);
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% inner_check_arguments()
%
function [megfile, active_swt] = inner_check_arguments(megfile, active_swt)
func_ = mfilename;
if isempty(megfile)
  error('(%s)megfile is a required parameter', func_);
end

if exist(megfile, 'file') ~= 2
  error('(%s)cannot find megfile : %s', func_, megfile);
end

if isempty(active_swt)
  active_swt = false;
end
return;
%
% --- end of inner_check_arguments()

%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
