function [label_list] = vb_megfile_get_channel_label_meg(megfile)
% return label list of MEG channels by reading megfile
% [usage]
%   [label_list] = vb_megfile_get_channel_label_meg(megfile)
% [input]
%   megfile : <required> <<file>> MEG-MAT file
% [output]
%   label_list : label list of MEG channel
% [note]
%   @see vb_meginfo_get_channel_label_meg
% [history]
%   2007-07-18 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('megfile', 'var') megfile = []; end
[megfile] = inner_check_arguments(megfile);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
label_list = [];

meginfo = vb_megfile_load_meginfo(megfile);
if isempty(meginfo)
  return;
end

label_list = vb_meginfo_get_channel_label_meg(meginfo);
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% inner_check_arguments()
%
function [megfile] = inner_check_arguments(megfile)
func_ = mfilename;
if isempty(megfile)
  error('(%s)megfile is a required parameter', func_);
end

if exist(megfile, 'file') ~= 2
  error('(%s)cannot find megfile : %s', func_, megfile);
end
return;
%
% --- end of inner_check_arguments()

%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
