function vb_megfile_remove_trial_ext(megfile,megfile_new)
% Remove trials based on external signals
%
% --- Syntax
% vb_megfile_remove_trial_ext(megfile, megfile_new, parm)
%
% --- History
% 2008-05-09 Taku Yoshioka
% 2010-01-22 (Matt) made more efficient
% 2010-01-26 (Sako) renamed
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% Default parameters
threshold = 8;
verbose = 2;   % verbose level
if nargin<1, help vb_megfile_remove_trial_ext; end

% Get information of MEG data
MEGinfo = vb_load_measurement_info(megfile);
ActTrial = vb_info_get_active_trial(MEGinfo);
ExtChannelName = vb_megfile_get_channel_label_extra(megfile);

clear load_spec;
load_spec.ActiveChannel = false;
load_spec.ChannelType = 'EXTRA';
[full_ext_data] = vb_load_meg_data(megfile,load_spec);

ext_data = full_ext_data(:,:,ActTrial==1);

clear load_spec;

% Find external channels having no information
Nc = size(ext_data,1);
ix_channel = [];
for i=1:Nc
  tmp = sum(abs(ext_data(i,:,:)),3);
  if std(tmp)~=0, ix_channel = [ix_channel; i]; end
end

% Plot signal time courses of all external channels
Nxmax = 3;
Nymax = 4;
j = 1;
while j>0
  figure;
  ixx_channel ...
      = (1+(j-1)*Nxmax*Nymax):min([length(ix_channel) j*Nxmax*Nymax]);
  Nx = min([length(ixx_channel) Nxmax]);
  Ny = ceil(length(ixx_channel)/Nx);
  for i=1:length(ixx_channel)
    subplot(Ny,Nx,i);
    ix_channel_org = ix_channel(ixx_channel(i));
    plot(ext_data(ix_channel_org,:,1));
    title(['Channel ' num2str(ix_channel_org) ': ' ...
           ExtChannelName{ix_channel_org}]);
  end
  if length(ix_channel)<=j*(Nxmax*Nymax), j=0;
  else j = j+1; end
end

% Select external channels
answer = inputdlg(['Input channel number(s) for choosing trials' ...
                   ' removed\n (e.g., [1 4 5])'], ...
                  'Input external channels');
close all;
if isempty(answer), return; 
elseif ~isempty(answer{1}), ix_channel = str2num(answer{1}); end

% Input threshold
for i=1:length(ix_channel)
  tmp = abs(ext_data(ix_channel(i),:,:));
  hist(tmp,100);
  th(i) = min([threshold*median(tmp(:)) max(tmp(:))]);
  yrange = ylim;
  line([th(i) th(i)],[yrange(1) yrange(2)],'LineStyle','--','Color','k');
  answer = inputdlg(['Input threshold value for channel' ...
                     num2str(ix_channel(i))],'Threshold for noisy signal', ...
                    1,{num2str(th(i),'%.1f')});
  close;
  if ~isempty(answer) && ~isempty(answer{1}), 
    th(i) = str2num(answer{1}); 
  end
end


% Find noisy trials
ActTrial = vb_info_get_active_trial(MEGinfo);
for i=1:MEGinfo.Nrepeat
  if ~ActTrial(i), continue; end 
  
  ext_data = full_ext_data(:,:,i);
  
  remove_trial = false;
  for j=1:length(ix_channel)
    if max(abs(ext_data(ix_channel(j),:)))>th(j), remove_trial=true; end
  end
  
  if remove_trial, 
    if verbose==2, 
      
      figure;
      for j=1:length(ix_channel)
        title(['Channel ' num2str(ix_channel(j))]);
        subplot(length(ix_channel),1,j);
        plot(ext_data(ix_channel(j),:));
      end
      remove_trial = questdlg(['Remove trial ' num2str(i) '?'], ...
                              'Remove trial','Yes','No','Yes');
      close; close;
    else
      remove_trial = 'Yes';
    end
  end
  if strcmp(remove_trial,'Yes'), ActTrial(i) = false; end
end

% Update MEGinfo struct
update_spec.preprocess_parm.parm = [];
update_spec.active_trial = ActTrial;
vb_msrmnt_make_preprocessed_file(megfile,update_spec,megfile_new);

