function	[A, B, C, D, Z] = vb_online_butter_init(freq,fsamp,Norder,Nch,type)
% Generate Butterworth bandpass filter matrix for Online calculation
% [A, B, C, D, Z] = vb_online_butter_init(freq,fsamp,Norder,Nch,type)
% type   : filter type : 'low', 'high' , 'band'
% freq   = cutoff freqency for type = 'low', 'high'
%          [flow  fhigh] : bandpass freqency for type = 'band'
% fsamp  = sampling freqency
% Norder = filter order
% Nch  : Dimension of input signal
% Z    : Internal state variable (Nch x Norder)
%
%	[A, B, C, D] = butter(Norder, freq/(fsamp/2));
%	A = A'; B = B'; C = C'; D = D';
%	A: Norder x Norder, 
%	B: 1 x Norder, 
%	C: Norder x 1, 
%	D: 1 x 1
%	Y = Z * C + U * D; % Output update
%	Z = Z * A + U * B; % Internal state variable update
%
% Masa-aki Sato
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if nargin ~= 5, error('nargin must be 5'); end;

switch	type
case	'band'
	if length(freq) ~= 2, error('two freqency required for bandpass'); end;
	[A, B, C, D] = butter(Norder, freq/(fsamp/2));
case	'low'
	if length(freq) ~= 1, error('one freqency required for lowpass'); end;
	[A, B, C, D] = butter(Norder, freq/(fsamp/2));
case	'high'
	if length(freq) ~= 1, error('one freqency required for highpass'); end;
	[A, B, C, D] = butter(Norder, freq/(fsamp/2) ,'high');
otherwise
	error('filter type is wrong');
end

A = A'; B = B'; C = C'; D = D';

Norder = size(A,1);
Z = zeros( Nch, Norder );

