function [p, f] = vb_fftpower(data, samplingrate)
% Calculate power spectrum using FFT
%
% - Input
%   data : Data (channel x time x trial)
%   samplingrate : Sampling rate [Hz]
%
% - Output
%   p : Power spectrum (channel x frequency x trial)
%   f : Frequency label (1 x frequency)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% Get the number of time points
Nt = size(data, 2);

% Rearrange dimensions
rdata = permute(data, [2 1 3]);% time x channel x trial

% Make frequency label
f = (0:(Nt-1))*samplingrate/Nt;

% Calculate power spectrum
p = abs(fft(rdata)).^2/Nt/Nt;

% Rearrange dimensions
p = permute(p, [2 1 3]);% channel x frequency x trial

% Make outputs
p = p(:, 1:fix(Nt/2), :);
f = f(1:fix(Nt/2));

