function y = vb_convert_freq(x,fs,fs2);
% Convert sampling frequency
% y = vb_convert_freq(x, fs, fs2);
% x : [channel x time x trial]
% fs  : original sampling frequency
% fs2 : new sampling frequency
% !! For downsampling, 
%    lowpass filtering should be done before using this
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

[N,T,Nr]=size(x);

if fs==fs2;
	y=x;
elseif mod(fs,fs2)==0;
	y=x(:,1:fs/fs2:T,:);
else
	xi  = 1:T;
	xii = 1:fs/fs2:T;
	TY  = length(xii);
	y   = zeros(N,TY,Nr);
	
	for i=1:N;
		y(i,:,:)=interp1(xi,x(i,:,:),xii);
	end;
end;
