function y = vb_channel_bias_remove(x,mode)
% Remove bias and a linear trend from multi channel data
%  y = vb_channel_bias_remove(x,mode)
% x : channel x time
% mode = 1: bias removal
%      = 2: bias and a linear trend removal
%
% Masa-aki Sato 2009-1-27
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if nargin == 1 | isempty(mode),	mode = 1; end

[Nch,T] = size(x);

% bias remove
x = vb_repadd( x, - mean(x,2));% sum(x,2) = 0 is not hold when T >> 1
x = vb_repadd( x, - mean(x,2));% repeat for numerical accuracy

switch	mode
case	1
	y = x;
case	2
	% x = a * t
	t = (1:T) - (T+1)/2; % sum(t)=0
	t = t/T;
	a = (x * t')./sum(t.^2);
	y = x - a * t;
end
	
