function vb_job_eeg_gateway(proj_root, meg_parm)
% This is a gateway function to job_eeg.
% [usage]
%   vb_job_eeg_gateway(proj_root, meg_parm)
% [input]
%   proj_root : <required> path for imported VBMEG files ['']
%             :  this is not used.
%    meg_parm : <required> <<struct>>
%             :  .Measurement      : measurement type ['EEG']
%             :  .device           : device name ['BIOSEMI']
%             :  .measurement_file : input (BDF) file (.bdf)
%             :  .pos_file         : position file (.pos.mat)
%             :  .output_file      : output file (.eeg.mat)
%             :                    : ['(yyyymmdd_HHMMSS).eeg.mat']
%             :  .bin_data_dir     : output directory for binary data files
%             :                    : this is a relative path from output_file
%             :  .eeginfo_version  : version of EEGinfo - unused []
%             :  .verbose_swt      : <<boolean>> [false]
% [output]
%   none
% [note]
%   @see vb_job_meg.m
%   @see vb_job_eeg_biosemi.m
%   @see vb_job_eeg_brainamp.m
%   read_bdf_spec is a struct for the destination function vb_job_eeg_biosemi.m
%   which has fields as follows
%     .bdf_file     : BDF file with valid path
%     .pos_file     : POS-MAT file with valid path
%     .device       : device name. 'BIOSEMI'
%     .output_dir   : output directory for EEG-MAT files ['.']
%     .eeg_file     : ['<date>.eeg.mat'] EEG-MAT file name
%     .bin_data_dir : output directory for binary data files
%                   : this is a relative path from output_dir
%     .eeginfo_version : <optional> [] version of EEGinfo - unused yet
% [history]
%   2008-02-14 (Sako) initial version
%   2008-02-26 (Sako) supported POS-MAT file
%   2008-03-26 (Sako) modified how to apply proj_root
%   2008-05-28 (Sako) changed format of meg_parm for EEG
%   2010-02-02 (Sako) modified default value of meg_parm.output_file
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('proj_root', 'var'), proj_root = []; end
if ~exist('meg_parm', 'var'), meg_parm = []; end
[proj_root, meg_parm] = inner_check_arguments(proj_root, meg_parm);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
switch(meg_parm.device)
    case 'BIOSEMI'
        % ----- make read_bdf_spec from meg_parm
        read_bdf_spec.bdf_file = meg_parm.measurement_file;
        read_bdf_spec.pos_file = meg_parm.pos_file;
        read_bdf_spec.device = meg_parm.device;
        read_bdf_spec.output_dir = proj_root;
        read_bdf_spec.eeg_file = meg_parm.output_file;
        read_bdf_spec.bin_data_dir = meg_parm.bin_data_dir;
        read_bdf_spec.eeginfo_version = meg_parm.eeginfo_version;
        vb_job_eeg_biosemi(read_bdf_spec, meg_parm.verbose_swt);
        eegfile = fullfile(proj_root, meg_parm.output_file);
        vb_save(eegfile, 'meg_parm');
    case 'BRAINAMP'
        % ---- make brain_amp_spec from meg_parm
        read_brain_amp_spec.bamp_file    = meg_parm.measurement_file;
        read_brain_amp_spec.pos_file     = meg_parm.pos_file;
        read_brain_amp_spec.device       = meg_parm.device;
        read_brain_amp_spec.output_dir   = proj_root;
        read_brain_amp_spec.eeg_file     = meg_parm.output_file;
        read_brain_amp_spec.bin_data_dir = '';
        read_brain_amp_spec.eeginfo_version = meg_parm.eeginfo_version;
        vb_job_eeg_brainamp(read_brain_amp_spec, meg_parm.verbose_swt);
        eegfile = fullfile(proj_root, meg_parm.output_file);
        vb_save(eegfile, 'meg_parm');
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [proj_root, meg_parm] = inner_check_arguments(proj_root, meg_parm)
func_ = mfilename;
if isempty(meg_parm)
  error('(%s)meg_parm is a required parameter', func_);
end

proj_root = vb_rm_trailing_slash(proj_root);

% ----- set default values as needed
%    meg_parm : <required> <<struct>>
%             :  .Measurement      : measurement type ['EEG']
%             :  .device           : device name ['BIOSEMI']
%             :  .measurement_file : input (BDF) file (.bdf)
%             :  .pos_file         : position file (.pos.mat)
%             :  .output_file      : output file (.eeg.mat)
%             :  .bin_data_dir     : output directory for binary data files
%             :                    : this is a relative path from output_file
%             :  .eeginfo_version  : version of EEGinfo - unused []
%             :  .verbose_swt      : <<boolean>> [false]

% if ~isfield(meg_parm, 'Measurement') || isempty(meg_parm.Measurement)
%   meg_parm.Measurement = 'EEG';
% end

if ~isfield(meg_parm, 'device') || isempty(meg_parm.device)
  meg_parm.device = 'BIOSEMI';
end

if ~isfield(meg_parm, 'measurement_file') || isempty(meg_parm.measurement_file)
  error('(%s)meg_parm.measurement_file is a required field', func_);
end

if ~isfield(meg_parm, 'pos_file') || isempty(meg_parm.pos_file)
  meg_parm.pos_file = [];
end

if ~isfield(meg_parm, 'output_file') || isempty(meg_parm.output_file)
  meg_parm.output_file = '';
end

if ~isfield(meg_parm, 'bin_data_dir') || isempty(meg_parm.bin_data_dir)
  meg_parm.bin_data_dir = '';
end

if ~isfield(meg_parm, 'eeginfo_version')
  meg_parm.eeginfo_version = [];
end

if ~isfield(meg_parm, 'verbose_swt') || isempty(meg_parm.verbose_swt)
  meg_parm.verbose_swt = false;
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
