function [EEGinfo] = vb_eeginfo_set_post_trigger(EEGinfo, value)
% set post-trigger value to current EEGinfo struct
% [usage]
%   [EEGinfo] = vb_eeginfo_set_post_trigger(EEGinfo, value)
% [input]
%   EEGinfo : <required> <<struct>> EEG information
%     value : <optional> value of post-trigger [[]]
% [output]
%   EEGinfo : <<struct>> updated EEGinfo
% [note]
%   
% [hisotory]
%   2007-06-29 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('EEGinfo', 'var') EEGinfo = []; end
if ~exist('value', 'var') value = []; end
[EEGinfo, value] = inner_check_arguments(EEGinfo, value);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
EEGinfo.Posttrigger = value;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [EEGinfo, value] = inner_check_arguments(EEGinfo, value)
func_ = mfilename;
if isempty(EEGinfo)
  error('(%s)EEGinfo is a required parameter', func_);
end

if isempty(value)
  % require no action - set empty
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
