function [eeginfo] = vb_eeginfo_set_header(eeginfo, header)
% set header data of Biosemi to EEGinfo
% [usage]
%   [eeginfo] = vb_eeginfo_set_header(eeginfo, header)
% [input]
%   eeginfo : <required> <<struct>> EEGinfo
%    header : <optional> <<struct>> Biosemi header data []
% [output]
%    eeginfo : updated EEGinfo
% [note]
%   device dependent data
% [history]
%   2011-05-27 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('eeginfo', 'var'), eeginfo = []; end
if ~exist('header', 'var'), header = ''; end
[eeginfo, header] = inner_check_arguments(eeginfo, header);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
eeginfo.device_info.Header = header;
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [eeginfo, header] = inner_check_arguments(eeginfo, header)
func_ = mfilename;
if isempty(eeginfo)
  error('(%s) eeginfo is a required parameter', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%--- END OF FILE ---%
