function [device] = vb_eeginfo_get_device(eeginfo)
% <<getter>> return device from EEGinfo
% [usage]
%   [device] = vb_eeginfo_get_device(eeginfo)
% [input]
%   eeginfo : <required> <<struct>> EEGinfo
% [output]
%    device : device name
% [note]
% 
% [history]
%   2008-02-26 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('eeginfo', 'var'), eeginfo = []; end
[eeginfo] = inner_check_arguments(eeginfo);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
if ~isfield(eeginfo, 'Device');
  device = '';
else
  device = eeginfo.Device;
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [eeginfo] = inner_check_arguments(eeginfo)
func_ = mfilename;
if isempty(eeginfo)
  error('(%s)eeginfo is a required parameter', func_);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %


%%% END OF FILE %%%
