function [ch_list] = vb_eeginfo_get_channel_label_extra(eeginfo, active_swt)
% return extra channel label list from EEGinfo struct
% [usage]
%   [ch_list] = vb_eeginfo_get_channel_label_extra(eeginfo, active_swt)
% [input]
%   eeginfo : <required> <<struct>> EEGinfo
%   active_swt : <optional> <<boolean>> [false]
%              :   true) return only active channels (EEG)
%              :  false) return all the channels (EEG)
% [output]
%   ch_list : valid channel label list
% [note]
%   .ExtraChannelInfo field keeps extra channels information
% [history]
%   2008-02-27 (Sako) initial version
%   2008-05-01 (Sako) added active_swt
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('eeginfo', 'var'), eeginfo = []; end
if ~exist('active_swt', 'var'), active_swt = []; end
[eeginfo, active_swt] = inner_check_arguments(eeginfo, active_swt);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
if ~isfield(eeginfo, 'ExtraChannelInfo') ...
    || ~isfield(eeginfo.ExtraChannelInfo, 'Channel_name')
  ch_list = [];
else
  ch_list = eeginfo.ExtraChannelInfo.Channel_name;
end

if isempty(ch_list) || ~active_swt
  return;
end

% ----- filter active channels
if isfield(eeginfo.ExtraChannelInfo, 'Channel_active')
  active_list = eeginfo.ExtraChannelInfo.Channel_active;
  if length(ch_list) ~= length(active_list)
    fprintf('(%s) different length - channels and active list\n', mfilename);
    return;
  end
  ch_list = ch_list(active_list == 1);
else
  fprintf('(%s) no active information for extra channel\n', mfilename);
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
function [eeginfo, active_swt] = inner_check_arguments(eeginfo, active_swt)
func_ = mfilename;
if isempty(eeginfo)
  error('(%s)eeginfo is a required parameter', func_);
end

if isempty(active_swt)
  active_swt = false;
end
return;
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
