function eegdata = vb_eegfile_load_internal_data(eegfile)
% return eeg data which is saved as an internal parameter in EEG-MAT file
% [usage]
%   eeg_data = vb_eegfile_load_internal_data(eegfile)
% [input]
%   eegfile : <required> <<file>> EEG-MAT file
% [output]
%   eegdata : EEG data [Nchannel x Nsample x Ntrial]
% [note]
%
% [history]
%   2008-02-29 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('eegfile', 'var'), eegfile = ''; end
[eegfile] = inner_check_arguments(eegfile);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
eeg = load(eegfile);
if isfield(eeg, 'eeg_data')
  eegdata = eeg.eeg_data;
else
  eegdata = [];
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %


% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [eegfile] = inner_check_arguments(eegfile)
func_ = mfilename;
if isempty(eegfile)
  error('(%s)eegfile is a required parameter', func_);
end

if exist(eegfile, 'file') ~= 2
  error('(%s)cannot find eegfile: %s', func_, eegfile);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
