function [ch_list] = vb_eegfile_get_channel_label(eegfile, active_swt, ch_type)
% return valid channel label list from eegfile
% [usage]
%   [channel_list] = vb_eegfile_get_channel_label(eegfile, active_swt, ch_type)
% [input]
%       eegfile : <required> <<file>> EEG-MAT file
%    active_swt : <optional> <<boolean>> [false] switch for active channel
%               :   true) return only active channels (EEG)
%               :  false) return all the channels (EEG)
%       ch_type : <optional> [0] | 1 | 2
%               :  0) all the channels
%               :  1) only sensor channels (except for external channels)
%               :  2) only external channels
% [output]
%       ch_list : channel label list [N x 1]
% [note]
%   @see vb_eeginfo_get_channel_label.m
% [history]
%   2007-08-02 (Sako) initial version
%   2008-05-01 (Sako) added active_swt
%   2009-07-17 (Sako) added ch_type
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('eegfile', 'var'), eegfile = []; end
if ~exist('active_swt', 'var'), active_swt = []; end
if ~exist('ch_type', 'var'), ch_type = []; end
[eegfile, active_swt, ch_type] = ...
  inner_check_arguments(eegfile, active_swt, ch_type);


% --- MAIN PROCEDURE --------------------------------------------------------- %
%
eeginfo = vb_eegfile_load_eeginfo(eegfile);

% --- sensor channels
if ch_type ~= 2
  eeg_ch = vb_eeginfo_get_channel_label(eeginfo, active_swt);
else
  eeg_ch = {};
end

% --- external channels
if ch_type ~= 1
  ext_ch = vb_eeginfo_get_channel_label_extra(eeginfo, active_swt);
else
  ext_ch = {};
end

ch_list = [eeg_ch;ext_ch];

% arrange to [N x 1]
ch_list = vb_util_arrange_list(ch_list, 0);
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [eegfile, active_swt, ch_type] = ...
  inner_check_arguments(eegfile, active_swt, ch_type)
func_ = mfilename;
if isempty(eegfile)
  error('(%s)eegfile is a required parameter', func_);
end

if exist(eegfile, 'file') ~= 2
  error('(%s)cannot find eegfile : %s', func_, eegfile);
end

if isempty(active_swt)
  active_swt = false;
end

if isempty(ch_type)
  ch_type = 0;
end
return;
%
% --- end of inner_check_arguments()

% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
