function bit_arrays = vb_eeg_make_channel_bit_array(status_data,target_ch,bit_len)
% make bit arrays of specified channels
% [usage]
%   bit_arrays = vb_eeg_make_channel_bit_array(status_data,target_ch,bit_len)
% [input]
%   status_data : <required> status data [1 x N]
%               : 80-ch data is usually the corresponding channel
%     target_ch : <required> target channels index number [1 x N]
%               : this is the index of trigger channels (normally 1-16)
%               : plural channels are accessible
%       bit_len : <optional> length of bit [24]
% [output]
%    bit_arrays : bit arrays which is extracted [N_channel x N_sample]
% [note]
% [history]
%   2007-01-11 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

vb_define_device;

% --- CHECK ARGUMENTS --- %
if ~exist('status_data', 'var'), status_data = []; end;
if ~exist('target_ch', 'var'), target_ch = []; end;
if ~exist('bit_len', 'var'), bit_len = []; end;
[status_data, target_ch, bit_len] = ...
  inner_check_arguments(status_data, target_ch, bit_len);


% --- MAIN PROCEDURE --------------------------------------------------------- %
%
% prepare buffers
data_len = size(status_data,2);
ch_num = size(target_ch,2);

BIT_LEN = bit_len;

% result sizes are [N_channel x N_sample]
bit_arrays = zeros(ch_num,data_len);

for nch = target_ch
  check_bit = 2 ^ (nch-1);
  bit_arrays(nch,:) = ...
    (vb_bitand_ex(status_data(:,:),check_bit,BIT_LEN) == check_bit);
end

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [status_data, target_ch, bit_len] = ...
  inner_check_arguments(status_data, target_ch, bit_len)

vb_define_device;

if isempty(status_data) error('status_data is a required parameter'); end;
if isempty(target_ch) error('target_ch is a required parameter'); end;
if isempty(bit_len)
  bit_len = DEFAULT_BIT_LEN;
end

% re-arrange for this function
status_data = vb_util_arrange_list(status_data, 1);
target_ch = vb_util_arrange_list(target_ch, 1);

% use valid channels
target_ch = target_ch(find(target_ch < bit_len));
if isempty(target_ch) error('no valid target_ch'); end;
%
% --- end of inner_check_arguments()

%%% END OF FILE %%%
