function [channel_label] = vb_brainamp_get_info(brainamp_file)
% get measurement info from brainamp file.
%
% [USAGE]
%    [channel_label] = vb_brainamp_get_info(brainamp_file);
%
% [INPUT]
%    brainamp_file : brain amp file(.eeg)
%
% [OUTPUT]
%    channel_label : {1, Nch} list of channel name.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if nargin ~= 1
    error('Please check usage of the function');
end
if exist(brainamp_file, 'file') ~= 2
    error('Specified brain amp file is invalid.');
end

%
% --- Main Procedure
%

% read header
sFile = in_fopen_brainamp(brainamp_file);


channel_label = {sFile.channelmat.Channel.Name}';
