function [msec_time, sample_num] = vb_util_sample2msectime2sample( ...
  sample_num, msec_time, sample_frequency)
% convert sample number to time[msec] or time[msec] to sample number
% [usage]
%   [msec_time, sample_num] = vb_util_sample2msectime2sample( ...
%     sample_num, msec_time, sample_frequency)
% [input]
%         sample_num : <optional> [[]]
%                    : if this is empty, it is tried to calculate sample number
%          msec_time : <optional> [[]]
%                    : if this is empty, it is tried to calculate time
%   sample_frequency : <required> sampling frequency [Hz]
% [output]
%          msec_time : calculated or given time list [msec]
%         sample_num : calculated or given list of sample number
% [note]
%   if 
% [history]
%   2006-12-21 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('sample_num', 'var') sample_num = []; end;
if ~exist('msec_time', 'var')  msec_time  = []; end;
if ~exist('sample_frequency', 'var') sample_frequency = []; end;
[sample_num, msec_time, sample_frequency] = ...
  inner_check_arguments( sample_num, msec_time, sample_frequency );

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
if isempty(sample_num) && ~isempty(msec_time)
  sample_num = (msec_time .* sample_frequency) ./ 1000;
end

if isempty(msec_time) && ~isempty(sample_num)
  msec_time = 1000 .* sample_num ./ sample_frequency;
end
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %


% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
% 
function [sample_num, msec_time, sample_frequency] = ...
  inner_check_arguments(sample_num, msec_time, sample_frequency);

if isempty(sample_frequency)
  error('sample_frequency is a required parameter');
end

if isempty(sample_num) && isempty(msec_time)
  error('neighther sample_num nor msec_time are empty');
end
%
% --- end of inner_check_argument()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
