function [status_list] = vb_util_get_bit_status(data, target_bit, bit_len)
% return list which expresses on/off status of specified bit
% [usage]
%   [status_list] = vb_util_get_bit_status(data, target_bit, bit_len)
% [input]
%          data : <required> data
%               :  [1 x Nsample]
%    target_bit : <optional> target bit list [1:16]
%               :  [1 x N] or [N x 1] e.g. [1 2 3]
%       bit_len : <optional> data bit length [24]
% [output]
%   status_list : bit status list [Ntarget_bit x Nsample]
% [note]
%   @see vb_bitand_ex.m
% [history]
%   2007-08-23 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('data', 'var') data = []; end
if ~exist('target_bit', 'var') target_bit = []; end
if ~exist('bit_len', 'var') bit_len = []; end
[data, target_bit, bit_len] = inner_check_arguments(data, target_bit, bit_len);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
status_list = zeros(size(target_bit,2), size(data,2));

list_cnt = 1;
for cur_bit = target_bit
  shift_len = cur_bit - 1;
  focus_bit = bitshift(1,shift_len);
  status = vb_bitand_ex(data, focus_bit, bit_len);
  status_list(list_cnt,find(status)) = 1;
  list_cnt = list_cnt + 1;
end

return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [data, target_bit, bit_len] = ...
  inner_check_arguments(data, target_bit, bit_len)
func_ = mfilename;

if isempty(data)
  error('(%s)data is a required parameter', func_);
end

if isempty(target_bit)
%   error('(%s)target_bit is a required parameter', func_);
  target_bit = 1:16;
end

target_bit = vb_util_arrange_list(target_bit, 1);

if isempty(bit_len)
  bit_len = 24;
end

err_bit = find(target_bit > bit_len);
if ~isempty(err_bit)
  warning('(%s)there are some bad bit : %d\n', err_bit);
  target_bit(err_bit) = [];
end

return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
