function [new_info, exp_data, read_ch_info] = vb_read_ch_data( ...
  old_info, to_read_swt, ch_list, time_from, time_to, verbose_swt)
% read experiment data from channel binary data file
% [usage]
%   [new_info, exp_data, read_ch_info] = vb_read_ch_data( ...
%       old_info, ...
%       output_path, to_read_swt, ch_list, time_from, time_to, verbose_swt)
% [input]
%       old_info : <required> <<struct>> MEGinfo or EEGinfo
%    to_read_swt : <optional> (true or false) purpose of "ch_list". [false]
%                :   true : ch_list is to read
%                :  false : ch_list is to omit
%        ch_list : <conditionally optional>
%                :  list of channel label that you want to get
%                :   if this "ch_list" is empty and ...
%                :     1) if "to_read_swt" is true ---> error
%                :     2) if "to_read_swt" is false --> read every channel
%      time_from : <optional> [msec]
%                :   beginning time that you want to get [0] (>=0)
%        time_to : <optional> [msec]
%                :   end of time that you want to get [end of data]
%                :   (>(time_from))
%    verbose_swt : <optional> switch to output verbose message [true]
% [output]
%       new_info : new information struct data
%                :   (EEGinfo -> EEGinfo, MEGinfo -> MEGinfo)
%       exp_data : experiment data ([Nchannel x Nsample x Ntrial])
% [note]
%   @see vb_read_ch_data_eeg
%   *** This function is DEPRECATED due to its incomplete check. ***
% [history]
%   2006-12-21 (Sako) initial version
%   2011-05-30 (Sako) modified to convert "Measurement" to upper case
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)
tic;

% load common definitions for biosemi functions of vbmeg
vb_define_device;

% --- CHECK ARGUMENT --- %
if ~exist('old_info', 'var'), old_info = []; end
if ~exist('to_read_swt', 'var'), to_read_swt = []; end
if ~exist('ch_list', 'var'), ch_list = []; end
if ~exist('time_from', 'var'), time_from = []; end
if ~exist('time_to', 'var'), time_to = []; end
if ~exist('verbose_swt', 'var'), verbose_swt = []; end

[old_info, to_read_swt, ch_list, time_from, time_to, verbose_swt] = ...
  inner_check_argument( ...
  old_info, to_read_swt, ch_list, time_from, time_to, verbose_swt);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
my_measurement = vb_info_get_measurement(old_info);
Measurement = upper(my_measurement);

switch Measurement
  case  'EEG'
    [new_info, exp_data, read_ch_info] = ...
      vb_read_ch_data_eeg(old_info, ...
        to_read_swt, ch_list, time_from, time_to, verbose_swt);
    
  case  'MEG'
    % not be implemented yet
    
  otherwise
    error('unexpected measurement : %s', my_measurement);
end
fprintf('=== READ CHANNEL DATA (%f[sec])=== \n', toc);
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %


% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_argument()
% 
function [old_info, to_read_swt, ch_list, time_from, time_to, verbose_swt] = ...
  inner_check_argument(old_info, ...
    to_read_swt, ch_list, time_from, time_to, verbose_swt)

if isempty(old_info)
  error('old_info is a required parameter');
end
% 
% --- end of inner_check_argument()

% --- END OF FILE --- %
