function	try_list = vb_plot_bad_trial(data,ix_try,flg)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

NXfig=2; NYfig=4; 
nfig = 0;
pfig = 1;
print_mode = 0;
basename = 'bad_trial';
% ymax = 100;
ymax = max(data(:));

[Nch, T, Ntry] = size(data);

% Bad Trial
Nbad  = length(ix_try);

dtitle = 'Input Bad trial numbers';
prompt = {'Bad trial numbers'};

try_list = [];
try_temp = [];

figure;

for n=1:Nbad
	ntry = ix_try(n);
	try_temp = [try_temp; ntry];
	
	nfig = nfig + 1; subplot(NYfig,NXfig,nfig); 
	
	ch = find(flg(:,ntry) > 0);
	y  = data(ch,:,ntry);
	plot(y')
	xlim([0 T])
	ylim([-ymax ymax])
	title(sprintf('Trial = %d',ntry))

	if nfig ==NXfig*NYfig | n==Nbad, 
		if print_mode==1
			fname = sprintf('%s%d.png',basename,pfig);
			pfig=pfig+1;
			orient landscape
			%orient portrait
			print(gcf,'-dpng',fname)
			clf;
		else
			fmode = menu('All Trials are Bad ?',...
					'YES','NO');
	
			if fmode == 2,
				answer = inputdlg(prompt,dtitle);
				try_temp = sscanf(answer{1},'%d');
				%try_temp = vb_setdiff2(try_temp,try_good);
			end
			try_list = [try_list; try_temp];
			try_temp = [];
		end
		clf; nfig=0; 
	end;

end

close

%try_good = vb_setdiff2([1:Ntry],try_list);

return
