function [result] = vb_posfile_remake_datafile(pos_file, data_file, new_file)
% remake MEG-MAT or EEG-MAT file by loading posfile
% [usage]
%   [result] = vb_posfile_remake_datafile(pos_file, data_file, new_file)
% [input]
%   pos_file : <required> <<file>> POS-MAT file
%  data_file : <required> <<file>> MEG-MAT or EEG_MAT file
%   new_file : <optional> new file name if you want [(update data_file)]
% [output]
%     result : result code
%            :  0) no problem
%            : >1) something wrong
%            :      1) bad pos_file
%            :      2) bad data_file
% [note]
%   @see vb_posfile_remake_megfile.m
%   @see vb_posfile_remake_eegfile.m
%
% [history]
%   2009-08-05 (Sako) initial version
%   2011-06-01 (Sako) converted return values of vb_load_device to upper case
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if nargin < 3
    new_file = '';
end

[measurement] = vb_load_device(data_file);
Measurement = upper(measurement);

switch Measurement
  case 'MEG'
    result = vb_posfile_remake_megfile(pos_file, data_file, new_file);
  case 'EEG'
    result = vb_posfile_remake_eegfile(pos_file, data_file, new_file);
  otherwise
    error('(%s) unknown Measurement : %s', mfilename, Measurement);
end

return;

% --- END OF FILE --- %
