function trans_info = vb_posfile_load_transinfo(posfile)
% read and return trans_info from POS-MAT file
% [usage]
%   trans_info = vb_posfile_load_transinfo(posfile)
% [input]
%   posfile : <required> <<file>> POS-MAT file
% [output]
%   trans_info : <<struct>> trans_info
% [note]
%
% [history]
%   2008-03-12 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('posfile', 'var'), posfile = ''; end
[posfile] = inner_check_arguments(posfile);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
trans_info = '';
load(posfile, 'trans_info');
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
function [posfile] = inner_check_arguments(posfile)
func_ = mfilename;
if isempty(posfile)
  error('(%s)posfile is a required parameter', func_);
end

if exist(posfile, 'file') ~= 2
  error('(%s)cannot find posfile: %s', func_, posfile);
end
return;
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
