function [define] = vb_define_set(prog_dir)
% Set constants
%
% --- History
% ????-??-?? ????
% 2008-11-27 Taku Yoshioka
%   Constants for verbose level
% 2009-01-26 Taku Yoshioka
% 2013-01-24 rhayashi   Added vb_define_file
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

define.DICOM = 1;	% DICOM file
define.BV_LEFT = 2;	% Brain-Voyager file (left-brain)
define.BV_RIGHT = 3;	% Brain-Voyager file (right-brain)
define.INF_LEFT = 4;	% Inflation model file (left-brain)
define.INF_RIGHT = 5;	% Inflation model file (right-brain)
define.BRAIN1 = 6;	% BRAIN file (in fMRI menu)
define.BRAIN2 = 7;	% BRAIN file (in MEG menu)
define.SPM = 8;		% SPM file
define.MEG = 9;		% MEG file
define.CORTEX = 10;	% CORTEX file
define.BASIS = 11;	% BASIS file
define.SAVE_DIR1 = 12;	% Save dirtctory (in BRAIN menu)
define.SAVE_DIR2 = 13;	% Save dirtctory (in Leadfield menu)

define = vb_define_extension(define);
define = vb_define_mode(define);
define = vb_define_coordinate(define);
define = vb_define_verbose(define);
define = vb_define_file(define, prog_dir);


% Maximum number of GUI instances
define.PLOTMEG_MAX = 2; 
define.PLOTCMAP_MAX = 2;
define.EDITAREA_MAX = 2;
define.EDITACT_MAX = 2;
define.VIEWLF_MAX = 2;
