function const_val = vb_define_const(measurement)
% return defined constants variables
% [usage]
%   const_val = vb_define_const(measurement);
% [input]
%   measurement : <optional> measurement string 'MEG' or 'EEG' for now ['MEG']
%               :  case-insensitive
% [output]
%     const_val : struct of constants
% [note]
%
% [history]
%   2009-07-27 (Sako) modified to define accordance with measurement
%   2009-10-14 (Sako) added 'USER' type
%   2022-06-03 (k_suzuki) added OPM' to measurement
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('measurement', 'var'), measurement = ''; end
[measurement] = inner_check_arguments(measurement);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
% --- data type

% ----- common type
const_val.DATA_TYPE_ALL       = 'ALL';
const_val.DATA_TYPE_EXTRA     = 'EXTRA';
const_val.DATA_TYPE_USER      = 'USER';

switch measurement
  case 'MEG'
    const_val.DATA_TYPE_MAIN      = 'MEG';
    const_val.DATA_TYPE_REFERENCE = 'REFERENCE';
    const_val.DATA_TYPE_MAG       = 'MAG';
    const_val.DATA_TYPE_AXIAL     = 'AXIAL';
    const_val.DATA_TYPE_PLANAR    = 'PLANAR';

    % For OPM (QZFM) device
    const_val.DATA_TYPE_MAG_X     = 'MAG_X';
    const_val.DATA_TYPE_MAG_Y     = 'MAG_Y';
    const_val.DATA_TYPE_MAG_Z     = 'MAG_Z';
      
  case 'EEG'
    const_val.DATA_TYPE_MAIN      = 'EEG';
  case 'INFO'
    const_val.DATA_TYPE_MAIN      = 'INFO';
  otherwise
    warning('(%s)unknown measurement : %s\n', mfilename, measurement);
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [measurement] = inner_check_arguments(measurement)
if isempty(measurement)
  measurement = 'MEG';
else
  measurement = upper(measurement);
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
