function [result, idx] = vb_util_is_included_list(base, target)
% check whether target list is included by base list
% [usage]
%   [result, idx] = vb_util_is_included_list(base, target)
% [input]
%     base : <required> base list. both numerical and string
%   target : <required> target list. both numerical and string.
%          :  but its type must be the same as base list
% [output]
%   result : <boolean>
%          :   true : base includes all the elments of target
%          :  false : all the elements of target are not included in base
%      idx : corresponding index of base list
% [note]
%   @see vb_util_check_numerical_lists.m
%   @see vb_util_check_string_lists.m
% [history]
%   2008-02-13 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('base', 'var'), base = []; end
if ~exist('target', 'var'), target = []; end
[base, target, mode] = inner_check_arguments(base, target);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
switch mode
  case 1 % numerical list
    [result, idx] = vb_util_check_numerical_lists(base, target);
  case 2 % string list
    [result, idx] = vb_util_check_string_lists(base, target);
  otherwise
    result = false;
    idx = [];
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [base, target, mode] = inner_check_arguments(base, target)
func_ = mfilename;
if isempty(base)
  error('(%s)base is a required parameter', func_);
end
if isempty(target)
  error('(%s)target is a required parameter', func_);
end

% decide mode - 1) numeric 2) string 3) different type
if isnumeric(base) && isnumeric(target)
  mode = 1; % numerical list
elseif ~isnumeric(base) && ~isnumeric(target)
  mode = 2; % string list
else
  mode = 3; % types are different
end
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %


%%% END OF FILE %%%
