function filebody = vb_util_get_file_body(fname)
% get body of file name by removing directory and extentions from 'fname'
% [usage]
%   filebody = vb_util_get_file_body(fname)
% [input]
%   fname : <required> <<string>> target file path
% [output]
%   filebody : body of filename without extention
% [note]
%   remove extentions recursively
% [history]
%   2006-10-11 (Sako) initial version
%   2007-06-22 (Sako) replaced fileparts to vb_get_file_parts (for MATLAB7.4.0)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('fname', 'var') fname = ''; end
[fname] = inner_check_arguments(fname);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
% [fdir,fbody] = fileparts(fname);
[fdir,fbody] = vb_get_file_parts(fname);
if isempty(strfind(fbody,'.'))
  filebody = fbody;
  return;
else
  filebody = vb_util_get_file_body(fbody);
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
function [fname] = inner_check_arguments(fname)

func_ = 'vb_util_get_file_body';

if length(fname) == 0
  error('(%s)fname is a required parameter', func_);
end
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %
%%% END OF FILE %%%
