function [ digit_num ] = vb_util_get_digit_number( target_num )
% return digit number
%
% [usage]
%   [ digit_num ] = vb_get_digit_number( target_num )
%
% [input]
%   target_num : <required> target number <<integer>>
%
% [output]
%   digit_num  : digit number of 'target_num'
%              : e.g.
%              :  23456 -> 5
%
% [note]
%   target_num must be integer.
%   Decimal number is truncated.
%
% [history]
%   2012-03-16 (Sako) initial version

% --- CHECK ARGUMENTS --- %
if ~exist('target_num', 'var'), target_num = []; end
[target_num] = inner_check_arguments(target_num);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
if target_num == 0
  digit_num = 0;
  return;
end

digit_num = 1;
while 1
  target_num = target_num / 10;
  if target_num < 1
    break;
  else
    digit_num = digit_num + 1;
  end
end
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [target_num] = inner_check_arguments(target_num)
func_ = mfilename;
if isempty(target_num)
  error('(%s) target_num is a required parameter', func_);
end

if ~isnumeric(target_num)
  error('(%s) target_num must be integer', func_);
end

target_num = abs(target_num);
target_num = floor(target_num);
return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

% --- END OF FILE --- %
