function txt = vb_struct2str(S)
%
% ¤Τʸ󥻥Ѵ
% 2003-04-30 Taku Yoshioka
% 2006-05-18 rhayashi : output formatted strings.
%                       adapt to structure including cell array.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

txt = fieldnames(S);

names = fieldnames(S);
Nmembers = length(names);

% get max string length of struct member
max_name_len = 0;
for k=1:Nmembers
    if max_name_len < length(names{k})
        max_name_len = length(names{k});
    end
end

% member name space padding(using max_name_len)
format = ['%' num2str(max_name_len) 's: %s'];

for i = 1:length(txt);
    member = S.(names{i});
    % cell array
    if iscell(member)
        cell_str = '{';
        for k=1:length(member)
            child_member = member{k};
            if iscell(child_member)
                % over level2 cell will not be expanded.
                cell_str = [cell_str, ' ', '''{ cell }'''];
            else
                % cell array strings connection
                cell_str = [cell_str, ' ', '''', num2str(child_member), '''']; 
            end
        end
        cell_str = [cell_str, ' }'];
        txt{i} = sprintf(format, names{i}, cell_str);
    else
        if isstruct(member), continue; end
        % character or number
        txt{i} = sprintf(format, names{i}, num2str(member));
    end
end;
