function vb_save_struct(filename, struct_obj)
% save the fields of "struct_obj" as individual variables
% [usage]
%   vb_save_struct(filename, struct_obj)
% [input]
%     filename : <required> <<file>> save the fields of "struct_obj" to this
%   struct_obj : <required> <<struct>> struct the fields of which are saved
% [output]
%   none
% [note]
%   @see vb_matlab_version.m
% [history]
%   2009-08-10 (Sako) initial version
%   2017-11-13 (rhayashi) create directory when save directory not exist
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('filename', 'var'), filename = ''; end
if ~exist('struct_obj', 'var'), struct_obj = []; end
[filename, struct_obj] = inner_check_arguments(filename, struct_obj);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
global vbmeg_saving_version

% [PATH, NAME, EXT] = fileparts(file_name);
[PATH, NAME, EXT] = vb_get_file_parts(filename);
if ~isempty(PATH) && ~exist(PATH, 'dir')
    vb_mkdir(PATH);
    vb_disp(['Create directory: ' PATH]);
end

EXT = '.mat';
filename = fullfile(PATH, [NAME, EXT]);

compatible_option = vbmeg_saving_version;

if vb_matlab_version('>=', '7')
  save_cmd = sprintf('save %s -struct struct_obj %s', filename, compatible_option);
else
  fields = fieldnames(struct_obj);
  n_field = length(fields);
  save_cmd = sprintf('vb_fsave(''%s''', filename);

  for i_field = 1:n_field
    cur_field = fields{i_field};

    save_cmd = sprintf('%s, ''%s''', save_cmd, cur_field);

    setvar_cmd = sprintf('%s = %s.%s;', cur_field, 'struct_obj', cur_field);
    eval(setvar_cmd);
  end
  save_cmd = [save_cmd ');'];
end

%fprintf('EXEC: %s\n', save_cmd);
eval(save_cmd);
return;
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [filename, struct_obj, result] = ...
  inner_check_arguments(filename, struct_obj)
func_ = mfilename;

if isempty(filename)
  error('(%s) filename is a required parameter', func_);
end

if isempty(struct_obj)
  error('(%s) struct_obj is a required parameter', func_);
end

[PATH, NAME, EXT] = vb_get_file_parts(filename);
if ~isempty(PATH) && ~exist(PATH, 'dir')
    vb_mkdir(PATH);
    vb_disp(['Create directory: ' PATH]);
end
EXT = '.mat';
filename = fullfile(PATH, [NAME, EXT]);

return;
%
% --- end of inner_check_arguments()
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
